﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Imports Microsoft.VisualBasic.FileIO

Public Class DeleteDirectoryPanel
    Inherits FileSystemSample.TaskPanelBase

#Region " Windows 窗体设计器生成的代码 "

    Public Sub New()
        MyBase.New()

        ' 此调用是 Windows 窗体设计器所必需的。
        InitializeComponent()

        ' 在 InitializeComponent() 调用之后添加任何初始化

    End Sub

    ' 窗体重写释放，以清理组件列表。
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    ' Windows 窗体设计器所必需的
    Private components As System.ComponentModel.IContainer

    ' 注意: 以下过程是 Windows 窗体设计器所必需的
    ' 可以使用 Windows 窗体设计器修改它。  
    ' 不要使用代码编辑器修改它。
    <System.Diagnostics.DebuggerNonUserCode()> Private Sub InitializeComponent()
        '
        'DescriptionTextBox
        '
        Me.DescriptionTextBox.Text = "Deletes a directory from the filesystem, optionally showing Windows shell dialogs" & _
            " and recursing the directory structure."
        '
        'DeleteDirectory
        '
        Me.Name = "DeleteDirectory"

    End Sub

#End Region


    Private Shared panelInstance As DeleteDirectoryPanel
    Friend WithEvents dirChooser As New DirectoryChooser()
    Friend WithEvents sendToRecycleBinComboBox As New ComboBox()
    Friend WithEvents showUIComboBox As New ComboBox()
    Friend WithEvents onUserCancelComboBox As New ComboBox()


    ''' <summary>
    ''' 获取此面板的全局实例
    ''' </summary>
    ''' <returns></returns>
    ''' <remarks></remarks>
    Public Shared Function GetInstance() As DeleteDirectoryPanel
        If (panelInstance Is Nothing) Then
            panelInstance = New DeleteDirectoryPanel
        End If
        Return panelInstance
    End Function

    ''' <summary>
    ''' 加载该面板，并将 My.Computer.FileSystem.DeleteDirectory() 的所有参数添加到该面板中。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub DeleteDirectoryPanel_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load
        InitializeUserControls()
        MyBase.AddParameter("directory", dirChooser)
        MyBase.AddParameter("showUI", showUIComboBox)
        MyBase.AddParameter("recycle", sendToRecycleBinComboBox)
        MyBase.AddParameter("onUserCancel", onUserCancelComboBox)
    End Sub



    ''' <summary>
    ''' 将该面板上的所有控件初始化为它们的默认状态
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub InitializeUserControls()
        MyBase.MethodNameLabel.Text = "My.Computer.FileSystem.DeleteDirectory("

        dirChooser.Reset()

        sendToRecycleBinComboBox.Items.AddRange(New String() {"True", "False"})
        sendToRecycleBinComboBox.AutoSize = True
        sendToRecycleBinComboBox.SelectedItem = "False"

        showUIComboBox.Items.AddRange(New String() {"True", "False"})
        showUIComboBox.AutoSize = True
        showUIComboBox.SelectedItem = "False"

        onUserCancelComboBox.Items.AddRange(New String() {"Do Nothing", "Throw Exception"})
        onUserCancelComboBox.AutoSize = True
        onUserCancelComboBox.SelectedItem = "Throw Exception"
    End Sub

    ''' <summary>
    ''' 用用户指定的参数调用 My.Computer.FileSystem.DeleteFile()。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ExececuteMethodButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ExececuteMethodButton.Click
        Try

            My.Computer.FileSystem.DeleteDirectory( _
                                        directory:=Me.dirChooser.Directory, _
                                        showUI:=CType(UIOption.Parse(GetType(UIOption), CType(Me.showUIComboBox.SelectedItem, String)), UIOption), _
                                        recycle:=CType(RecycleOption.Parse(GetType(RecycleOption), CType(Me.sendToRecycleBinComboBox.SelectedItem, String)), RecycleOption), _
                                        onUserCancel:=ParseUICancelOption(Me.onUserCancelComboBox))
        Catch ex As Exception
            MessageBox.Show(ex.Message)
        End Try

    End Sub

    ''' <summary>
    ''' 将该面板重置为其初始状态。
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Private Sub ResetValuesButton_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ResetValuesButton.Click
        InitializeUserControls()
    End Sub
End Class
